<?php
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// যদি ইউজার ইতিমধ্যে লগইন করা থাকে
if (is_user_logged_in()) {
    redirect('dashboard.php');
}

$error = '';
$success = '';

// লগইন ফর্ম প্রসেস
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['login'])) {
    $phone = trim($_POST['phone']);
    $password = trim($_POST['password']);
    
    if (empty($phone) || empty($password)) {
        $error = "ফোন নম্বর এবং পাসওয়ার্ড দিতে হবে";
    } else {
        $user = db_fetch("SELECT * FROM users WHERE phone = ?", [$phone]);
        
        if ($user && password_verify($password, $user['password'])) {
            if ($user['status'] == 'active') {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_role'] = 'user';
                $_SESSION['user_uiid'] = $user['uiid'];
                
                // লাস্ট লগইন আপডেট
                db_update('users', ['last_login' => date('Y-m-d H:i:s')], ['id' => $user['id']]);
                
                redirect('dashboard.php');
            } else {
                $error = "আপনার অ্যাকাউন্ট নিষ্ক্রিয় করা হয়েছে";
            }
        } else {
            $error = "ভুল ফোন নম্বর বা পাসওয়ার্ড";
        }
    }
}

// রেজিস্ট্রেশন ফর্ম প্রসেস
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['register'])) {
    $name = trim($_POST['name']);
    $phone = trim($_POST['phone']);
    $password = trim($_POST['password']);
    $confirm_password = trim($_POST['confirm_password']);
    $referral_code = trim($_POST['referral_code'] ?? '');
    
    // ভ্যালিডেশন
    if (empty($name) || empty($phone) || empty($password)) {
        $error = "সব তথ্য পূরণ করুন";
    } elseif ($password !== $confirm_password) {
        $error = "পাসওয়ার্ড মিলেনি";
    } elseif (strlen($password) < 6) {
        $error = "পাসওয়ার্ড কমপক্ষে ৬ অক্ষর হতে হবে";
    } else {
        // চেক করুন ফোন নম্বর ইতিমধ্যে আছে কিনা
        $existing = db_fetch("SELECT id FROM users WHERE phone = ?", [$phone]);
        if ($existing) {
            $error = "এই ফোন নম্বর ইতিমধ্যে রেজিস্টার্ড";
        } else {
            // ইউনিক UIID জেনারেট
            $uiid = 'BD' . rand(100000, 999999);
            
            // রেফারেল চেক
            $referrer_id = null;
            if (!empty($referral_code)) {
                $referrer = db_fetch("SELECT id FROM users WHERE uiid = ?", [$referral_code]);
                if ($referrer) {
                    $referrer_id = $referrer['id'];
                }
            }
            
            // ইউজার তৈরি
            $user_data = [
                'uiid' => $uiid,
                'name' => $name,
                'phone' => $phone,
                'password' => password_hash($password, PASSWORD_DEFAULT),
                'referral_code' => $referral_code ?: null,
                'referrer_id' => $referrer_id,
                'deposit_balance' => WELCOME_BONUS,
                'winning_balance' => 0,
                'status' => 'active',
                'created_at' => date('Y-m-d H:i:s')
            ];
            
            $user_id = db_insert('users', $user_data);
            
            if ($user_id) {
                // রেফারেল বোনাস
                if ($referrer_id) {
                    db_update('users', 
                        ['winning_balance' => 'winning_balance + ' . REFERRAL_BONUS, 'total_referrals' => 'total_referrals + 1'],
                        ['id' => $referrer_id]
                    );
                }
                
                $success = "রেজিস্ট্রেশন সফল! আপনার UI ID: $uiid";
                // অটো লগইন
                $_SESSION['user_id'] = $user_id;
                $_SESSION['user_role'] = 'user';
                $_SESSION['user_uiid'] = $uiid;
                
                redirect('dashboard.php');
            } else {
                $error = "রেজিস্ট্রেশন ব্যর্থ, আবার চেষ্টা করুন";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BD CLUB - লগইন</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .auth-container {
            max-width: 400px;
            margin: 50px auto;
            padding: 20px;
            background: #1a1a1a;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,255,200,0.1);
        }
        
        .auth-tabs {
            display: flex;
            margin-bottom: 20px;
            border-bottom: 1px solid #333;
        }
        
        .auth-tab {
            flex: 1;
            padding: 10px;
            text-align: center;
            cursor: pointer;
            color: #888;
            border-bottom: 2px solid transparent;
        }
        
        .auth-tab.active {
            color: #00ffc8;
            border-bottom-color: #00ffc8;
        }
        
        .auth-form {
            display: none;
        }
        
        .auth-form.active {
            display: block;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #ccc;
        }
        
        .form-group input {
            width: 100%;
            padding: 10px;
            background: #2a2a2a;
            border: 1px solid #444;
            border-radius: 5px;
            color: white;
        }
        
        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #00ffc8, #00aaff);
            border: none;
            border-radius: 5px;
            color: #000;
            font-weight: bold;
            cursor: pointer;
        }
        
        .alert {
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
        }
        
        .alert-error {
            background: #ff3333;
            color: white;
        }
        
        .alert-success {
            background: #00cc66;
            color: white;
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <h2 style="text-align: center; color: #00ffc8; margin-bottom: 30px;">BD CLUB</h2>
        
        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <div class="auth-tabs">
            <div class="auth-tab active" onclick="showForm('login')">লগইন</div>
            <div class="auth-tab" onclick="showForm('register')">রেজিস্ট্রেশন</div>
        </div>
        
        <!-- লগইন ফর্ম -->
        <form method="POST" class="auth-form active" id="login-form">
            <input type="hidden" name="login" value="1">
            <div class="form-group">
                <label>ফোন নম্বর</label>
                <input type="text" name="phone" required>
            </div>
            <div class="form-group">
                <label>পাসওয়ার্ড</label>
                <input type="password" name="password" required>
            </div>
            <button type="submit" class="btn">লগইন</button>
        </form>
        
        <!-- রেজিস্ট্রেশন ফর্ম -->
        <form method="POST" class="auth-form" id="register-form">
            <input type="hidden" name="register" value="1">
            <div class="form-group">
                <label>পুরো নাম</label>
                <input type="text" name="name" required>
            </div>
            <div class="form-group">
                <label>ফোন নম্বর</label>
                <input type="text" name="phone" required>
            </div>
            <div class="form-group">
                <label>পাসওয়ার্ড</label>
                <input type="password" name="password" required>
            </div>
            <div class="form-group">
                <label>পাসওয়ার্ড নিশ্চিত করুন</label>
                <input type="password" name="confirm_password" required>
            </div>
            <div class="form-group">
                <label>রেফারেল কোড (ঐচ্ছিক)</label>
                <input type="text" name="referral_code">
            </div>
            <button type="submit" class="btn">রেজিস্টার</button>
        </form>
    </div>
    
    <script>
        function showForm(formId) {
            // ট্যাব এক্টিভ করা
            document.querySelectorAll('.auth-tab').forEach(tab => {
                tab.classList.remove('active');
            });
            event.target.classList.add('active');
            
            // ফর্ম দেখানো
            document.querySelectorAll('.auth-form').forEach(form => {
                form.classList.remove('active');
            });
            document.getElementById(formId + '-form').classList.add('active');
        }
    </script>
</body>
</html>