<?php
require_once 'config.php';

// ডাটাবেজ কানেকশন
try {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        throw new Exception("Database connection failed: " . $conn->connect_error);
    }
    
    $conn->set_charset("utf8mb4");
    
} catch (Exception $e) {
    die("Database Error: " . $e->getMessage());
}

// ফাংশন: নিরাপদ SQL কুয়েরি
function db_query($sql, $params = []) {
    global $conn;
    
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        return false;
    }
    
    if (!empty($params)) {
        $types = str_repeat('s', count($params));
        $stmt->bind_param($types, ...$params);
    }
    
    $stmt->execute();
    return $stmt;
}

// ফাংশন: সিঙ্গল রো ফেচ
function db_fetch($sql, $params = []) {
    $stmt = db_query($sql, $params);
    if ($stmt) {
        $result = $stmt->get_result();
        return $result->fetch_assoc();
    }
    return false;
}

// ফাংশন: মাল্টিপল রো ফেচ
function db_fetch_all($sql, $params = []) {
    $stmt = db_query($sql, $params);
    if ($stmt) {
        $result = $stmt->get_result();
        $rows = [];
        while ($row = $result->fetch_assoc()) {
            $rows[] = $row;
        }
        return $rows;
    }
    return [];
}

// ফাংশন: ইনসার্ট
function db_insert($table, $data) {
    global $conn;
    
    $keys = array_keys($data);
    $values = array_values($data);
    $placeholders = str_repeat('?,', count($values) - 1) . '?';
    
    $sql = "INSERT INTO $table (" . implode(',', $keys) . ") VALUES ($placeholders)";
    $stmt = db_query($sql, $values);
    
    if ($stmt) {
        return $conn->insert_id;
    }
    return false;
}

// ফাংশন: আপডেট
function db_update($table, $data, $where) {
    $sets = [];
    $values = [];
    
    foreach ($data as $key => $value) {
        $sets[] = "$key = ?";
        $values[] = $value;
    }
    
    $where_clause = '';
    $where_values = [];
    
    foreach ($where as $key => $value) {
        $where_clause = "$key = ?";
        $where_values[] = $value;
    }
    
    $values = array_merge($values, $where_values);
    $sql = "UPDATE $table SET " . implode(', ', $sets) . " WHERE $where_clause";
    
    $stmt = db_query($sql, $values);
    return $stmt ? $stmt->affected_rows : false;
}

// ফাংশন: ডিলিট
function db_delete($table, $where) {
    $where_clause = '';
    $values = [];
    
    foreach ($where as $key => $value) {
        $where_clause = "$key = ?";
        $values[] = $value;
    }
    
    $sql = "DELETE FROM $table WHERE $where_clause";
    $stmt = db_query($sql, $values);
    return $stmt ? $stmt->affected_rows : false;
}
?>